<?php
/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */

 !defined('DL_Root') && exit ( 'Access Denied!' );
 
class DuoLamBase{

	public static $config = array();

	public static $_config = array();

	private static $_app;

	protected function Init()
	{
		session_start();
		self::$config = require(APP_PATH . 'Config'. DS . 'Config.inc.php');
		self::$_config = require(DL_Root . 'CoreConfig' . DS . 'DCoreConfig.php'); unset(self::$_config['core']);
		header('Content-type: text/html;charset={'.self::$config['frame']['CharSet'].'}');
		$this->initLoad();
		if(self::$config['frame']['Debug'])
		{
			error_reporting(E_ALL);
			set_error_handler(array('self', 'e'));
		}
		else
		{
			error_reporting(0);
		}
		self::$config['frame']['time'] = microtime(true);
		PHP_VERSION > '5.1' && @date_default_timezone_set(self::$config['frame']['TimeZone']);
		if(self::$config['frame']['Gzip']) function_exists('gz_gzhandler') ? ob_start('gz_gzhandler') : ob_start();
		require_once DL_Root . 'Frame' . DS . 'core' . DS . 'CacheDriver' . DS . self::$config['cache']['driver'].'.php';
		self::app('DController');
	}

	final private function initLoad()
	{
		foreach(self::$config['import'] as $v)
		{
			self::import($v);
		}
	}

	final public static function version()
	{
		return '1.0';
	}
	
	final public static function app($app,$config='')
	{
		empty($app) && DEr::notice('没有可执行的应用');
		class_exists($app) or DEr::notice('该应用不存在：'.$app);
		if(!isset(self::$_app[$app]))
		{
			self::$_app[$app] = new $app($config);
			return self::$_app[$app];
		}
		return self::$_app[$app];
	}

	final public static function import($path,$suffix='.php')
	{
		$path = explode('.' , $path);
		$pathname = $path[0];
		$maxnum = $path[count($path)-1];
		$longpath = $filename = null;
		self::$_config['ext']['suffix'] = $suffix;
		if(array_key_exists($pathname,self::$config['path']))
		{
			unset($path[0]);
			$longpath = self::$config['path'][$pathname];
			$filename = $longpath . DS . implode(DS , $path) . $suffix;
			if($maxnum=='*')
			{
				unset($path[count($path)]);
				self::$_config['ext']['dir'][] = $longpath . DS . implode(DS , $path);
				return true;
			}
		}
		else
		{
			if($maxnum=='*')
			{
				unset($path[count($path)-1]);
				self::$_config['ext']['dir'][] = implode(DS , $path) . DS;
				return true;
			}
			$filename = implode(DS , $path) . $suffix;
		}
		if(is_file($filename))
		{
			include_once $filename;
		}
		else
		{
			DEr::notice('载入的文件不存在！' . $filename);
		}
	}

	final public static function autoload($classname)
	{
		$path = DL_Root . 'Frame' . DS;
		if(is_file($path . 'lib' . DS . $classname . '.php') && in_array($classname,self::$_config['lib']))
		{
			include_once $path . 'lib' . DS . $classname . '.php';
		}
		else if(is_file($path . 'ext' . DS . $classname . '.php' && in_array($classname,self::$_config['ext'])))
		{
			include_once $path . 'ext' . DS . $classname . '.php';
		}
		else if(!empty(self::$_config['ext']['dir']))
		{
			foreach(self::$_config['ext']['dir'] as $k => $v)
			{
				$file = $v . $classname . self::$_config['ext']['suffix'];
				if(!is_file($file))
				{
					break;
				}
				include_once $file;
			}
		}
		else
		{
			if(stripos($classname,'Share' === false) or $classname == 'Action'.C)
			{
				DEr::notice('要载入文件：'.$classname.' 失败，该文件并不存在!');
			}
		}
	}


	final public static function url()
	{
		$_self = empty($_SERVER['PHP_SELF']) ? $_SERVER['SCRIPT_NAME'] : $_SERVER['PHP_SELF'];
		$_self  =  explode('/',$_self);
		$key = array_search('index.php',$_self);
		$self = null;
		for($i=$key; $i>=0; $i--)
		{
			if($_self[$i] !== 'index.php') $self = $_self[$i] . '/' .  $self;
			unset($_self[$i]);
		}
		return $self;
	}

	final public static function uview()
	{
		return self::url().'Views'. '/';
	}

	final public static function ucache()
	{
		return self::url().'Cache'.'/';
	}

	final public static function path()
	{
		return self::$config['frame']['mode'] == 1 ? self::url() . 'index.php/' : self::url();
	}

	final public static function e($num,$msg='',$file,$line)
	{
		DEr::error($msg);
	}
	
	static function returnApp()
	{
		return self::$_app;
	}
}
?>